/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.link;

import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.link.LinkAlreadyActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;

public class InternetVpnLink
extends RcsLink {
    private static final String TRACE_MASKT = "XRCSLIVT";
    private static final String TRACE_MASKF = "XRCSLIVF";
    private static final String TRACE_MASKD = "XRCSLIVD";
    private static InternetVpnLink instance;

    protected InternetVpnLink() {
        this.maxOpenPaths = 5;
        Trace.trace(TRACE_MASKT, "<-> InternetVpnLink()");
    }

    public static RcsLink getInstance() {
        if (instance == null) {
            instance = new InternetVpnLink();
        }
        Trace.trace(TRACE_MASKT, "<-> getInstance() [" + instance + "]");
        return instance;
    }

    public void activate() throws LinkAlreadyActiveException, LinkFailedException, LinkNotConfiguredException {
        Trace.trace(TRACE_MASKT, "--> activate()");
        if (this.active) {
            throw new LinkAlreadyActiveException();
        }
        if (!this.isConfigured()) {
            throw new LinkNotConfiguredException();
        }
        try {
            int rc = RcsControl.startVpn();
            if (rc != 0) {
                this.active = false;
                throw new LinkFailedException("Failed to start VPN (RC: " + rc + ")");
            }
            this.active = true;
        }
        catch (LinkFailedException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
            throw new LinkFailedException(e);
        }
        Trace.trace(TRACE_MASKT, "<-- activate()");
    }

    public void deactivate() {
        Trace.trace(TRACE_MASKT, "--> deactivate()");
        try {
            RcsControl.stopVpn();
            this.active = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- deactivate()");
    }

    public boolean fail() {
        Trace.trace(TRACE_MASKT, "--> fail()");
        boolean fail = false;
        if (this.active) {
            this.deactivate();
        }
        Trace.trace(TRACE_MASKT, "<-- fail() [" + fail + "]");
        return fail;
    }

    public boolean isConfigured() {
        OutboundConfigData data = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        boolean configured = data.isCallHomeServer() && data.isAllowInternet() && super.isConfigured();
        Trace.trace(TRACE_MASKT, "<-> isConfigured() [" + configured + "]");
        return configured;
    }

    public boolean isHighPerformanceLink() {
        Trace.trace(TRACE_MASKT, "<-> isHighPerformanceLink() [true]");
        return true;
    }
}

